/*

	Golang DSP Openrtb v3.0 & v2.5
	Author : MK

*/

package main

import (
	"bytes"
	"compress/gzip"
	"crypto/tls"
	"database/sql"
	"djad"
	"os"
	"os/exec"
	"strings"

	//~ "djblowfish"
	"djconstants"
	"djdb"
	"djextrafunc"
	"djlogger"
	"djmongo"
	"djvalidate"
	"encoding/base64"

	//~ "encoding/hex"
	"djredis"
	"encoding/json"
	"fmt"
	"gocron"
	"gorilla/mux"
	"io"
	"io/ioutil"
	"log"
	"mongo/bson"
	"net/http"
	openrtb3 "openrtb/openrtb3"
	"strconv"
	"time"

	openrtb "openrtb/openrtb2.5"
)

var redisClient = djredis.Initialize()

// addCookie will apply a new cookie to the response of a http
// request, with the key/value this method is passed.
func addCookie(w http.ResponseWriter, name string, value string) {
	expire := time.Now().AddDate(0, 0, 1)
	cookie := http.Cookie{
		Name:    name,
		Value:   value,
		Expires: expire,
	}
	http.SetCookie(w, &cookie)
}

// Home Function
func home(w http.ResponseWriter, r *http.Request) {
	html := `<html>
				<title>Golang DSP API</title>    
					<body>
						<h1>` + djconstants.AppName + `</h1>
					</body>
			</html>`
	w.Write([]byte(fmt.Sprintf(html)))
}
func validataion(w http.ResponseWriter, r *http.Request) {
	html := `loaderio-69ca9df62735546fd9d77b7059b55b83`
	w.Write([]byte(fmt.Sprintf(html)))
}

func samplerequest(w http.ResponseWriter, r *http.Request) {

	w.Header().Add("Accept-Charset", "utf-8")
	w.Header().Add("Content-Type", "application/json")

	html := `{"bidid":"255fc47cbbbc568978151f82cb_2020113050","cur":"USD","ext":{"pixelurl":""},"id":"255fc47cbbbc568978151f82cb_2020113050","seatbid":[{"bid":[{"id":"89827f2142b37822","impid":"1","price":12,"adid":"154","nurl":"http://69.61.32.103:8090/win_notice?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE:BF}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}","burl":"http://69.61.32.103:8090/billing_notice?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE:BF}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}","lurl":"http://69.61.32.103:8090/loss_notice?auctionId=${AUCTION_ID}&bidid=${AUCTION_BID_ID}&price=${AUCTION_PRICE:BF}&impid=${AUCTION_IMP_ID}&seatid=${AUCTION_SEAT_ID}&adid=${AUCTION_AD_ID}&cur=${AUCTION_CURRENCY}&lossid=${AUCTION_LOSS}","adm":"<a href='http://69.61.32.103:8090/click_url?bannerid=154&zoneid=0&oadest=http://google.com&bidid=255fc47cbbbc568978151f82cb_2020113050&cookieid=7099d748911383080b4ae323236b678c7322&campaignid=42' target='_blank'><img src='http://13.234.135.218/advanceddspgo/www/images/b6e5b7d03d0f5359569076b820d9ff95.jpg' width='300' height='250' alt='' title='' border='0'></a><div id='beacon_7c6e120e13' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='http://69.61.32.103:8090/imp_url?bannerid=154&campaignid=42&zoneid=0&bidid=255fc47cbbbc568978151f82cb_2020113050' width='0' height='0' alt='' style='width: 0px; height: 0px;' /><img src='' width='0' height='0' alt='' style='width: 0px; height: 0px;' /><img src='http://69.61.32.103:8090/rubicon_dmp_pixel?nid={ad_network_id}&cookieid=7099d748911383080b4ae323236b678c7322' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div>","adomain":["69.61.32.103"],"cid":"42","crid":"154","h":250,"w":300,"ext":{"btype":1}}],"seat":"abcd_Advertiser_66"}]}`
	w.Write([]byte(fmt.Sprintf(html)))
}

// Function for calculating request elapsed time
func elapsed(what string) func() {
	start := time.Now()
	return func() {
		djlogger.Log.Printf("%s took %v\n", what, time.Since(start))
	}
}

// Function for getting incoming request details
func getRequestDetails(r *http.Request) map[string]interface{} {
	req_details := make(map[string]interface{})
	req_details["dsp_name"] = r.URL.Query().Get("dsp")
	req_details["key"] = r.URL.Query().Get("secret_key")
	req_details["Method"] = r.Method
	req_details["URL"] = r.URL.String()
	req_details["Proto"] = r.Proto
	req_details["Host"] = r.Host
	req_details["RemoteAddr"] = r.RemoteAddr
	for k, v := range r.Header {
		req_details[k] = v
	}
	return req_details
}

// Function for getting incoming process details
func getProcessDetails(r *http.Request) map[string]interface{} {
	pro_details := make(map[string]interface{})
	pro_details["bidid"] = r.URL.Query().Get("bidid")
	pro_details["auctionId"] = r.URL.Query().Get("auctionId")

	if djextrafunc.StringToFloat(r.URL.Query().Get("price"), 64) != 0 {
		pro_details["price"] = r.URL.Query().Get("price")
	} else {
		pro_details["price"] = r.URL.Query().Get("price")
		if pro_details["price"] != "SCREENING" {

			//~ fmt.Println(pro_details["price"].(string))
			//~ decoded, err := hex.DecodeString(pro_details["price"].(string))
			//~ if err != nil {
			//~ djlogger.Log.Println(err)
			//~ } else {
			//~ pro_details["price"] = djblowfish.BlowfishDecrypt([]byte(decoded), []byte(djconstants.BlowfishKey))
			//~ }
		}
	}

	pro_details["currency"] = r.URL.Query().Get("cur")
	pro_details["impid"] = r.URL.Query().Get("impid")
	pro_details["seatid"] = r.URL.Query().Get("seatid")
	pro_details["adid"] = r.URL.Query().Get("adid")
	pro_details["lossid"] = r.URL.Query().Get("lossid")
	defer func() {
		if err := recover(); err != nil {
			djlogger.Log.Println("Error occured : ", err, " Recovered from panic")
		}
	}()
	return pro_details
}

// Function to convert gzip request body
func Getgzip(body io.ReadCloser) (*gzip.Reader, error) {
	buf := new(bytes.Buffer)
	buf.ReadFrom(body)
	newStr := buf.String()
	z, err := base64.StdEncoding.DecodeString(newStr)
	if err != nil {
		rgzip, err := gzip.NewReader(bytes.NewReader([]byte(newStr)))
		defer rgzip.Close()
		if err != nil {
			return nil, err
		}
		return rgzip, nil
	}
	rgzip, err := gzip.NewReader(bytes.NewReader(z))
	defer rgzip.Close()
	if err != nil {
		return nil, err
	}
	return rgzip, nil
}

// Function for processing incoming request
func processRequest(w http.ResponseWriter, r *http.Request) {

	fmt.Println("processRequest called")
	var cookieDmp string
	// Read cookie
	cookie, err := r.Cookie("dmp")
	if err == http.ErrNoCookie {
		djlogger.Log.Println("Cannot able to find dmp cookie")
	} else {
		cookieDmp = cookie.Value
	}
	defer elapsed("Request")()
	RequestDetails := getRequestDetails(r)
	RequestDetails["cookie"] = cookieDmp
	ResponseArray := make(map[string]interface{})
	if r.Header.Get("x-openrtb-version") == "" || r.Header.Get("x-openrtb-version") == "2.5" {
		RequestArray := &openrtb.BidRequest{}
		switch r.Header.Get("Content-Encoding") {
		case "gzip", "application/gzip":
			// create header
			w.Header().Add("Accept-Charset", "utf-8")
			w.Header().Add("Content-Type", "application/json")
			w.Header().Set("Content-Encoding", "gzip")
			rgzip, errr := Getgzip(r.Body)
			if errr != nil {
				//ResponseArray["message"] = "Request Content-Encoding Error"
				ResponseArray["nbr"] = 2
				w.WriteHeader(http.StatusBadRequest)
				json.NewEncoder(w).Encode(ResponseArray)
				return
			}
			result, _ := ioutil.ReadAll(rgzip)
			err := json.NewDecoder(bytes.NewReader(result)).Decode(&RequestArray)
			if err != nil {
				//ResponseArray["message"] = "Request Error"
				ResponseArray["nbr"] = 2
				w.WriteHeader(http.StatusBadRequest)
				json.NewEncoder(w).Encode(ResponseArray)
				return
			}

			ResponseArray = getAD25(RequestArray, RequestDetails)
			if len(ResponseArray) == 0 {
				w.WriteHeader(http.StatusNoContent)
				return
			} else {
				w.WriteHeader(http.StatusOK)
				gz := gzip.NewWriter(w)
				json.NewEncoder(gz).Encode(ResponseArray)
				gz.Close()
				return
			}
		default:
			// create header
			w.Header().Add("Content-Type", "application/json")
			err := json.NewDecoder(r.Body).Decode(&RequestArray)
			if err != nil {
				//ResponseArray["message"] = "Request Error"
				ResponseArray["nbr"] = 2
				w.WriteHeader(http.StatusBadRequest)
				json.NewEncoder(w).Encode(ResponseArray)
				return
			}
			ResponseArray = getAD25(RequestArray, RequestDetails)
			if len(ResponseArray) == 0 {
				w.WriteHeader(http.StatusNoContent)
				return
			} else {
				w.WriteHeader(http.StatusOK)
				json.NewEncoder(w).Encode(ResponseArray)
				return
			}
		}
	} else if r.Header.Get("x-openrtb-version") == "3.0" {
		RequestArray := &openrtb3.Request{}
		switch r.Header.Get("Content-Encoding") {
		case "gzip", "application/gzip":
			// create header
			w.Header().Add("Accept-Charset", "utf-8")
			w.Header().Add("Content-Type", "application/json")
			w.Header().Set("Content-Encoding", "gzip")
			rgzip, errr := Getgzip(r.Body)
			if errr != nil {
				//ResponseArray["message"] = "Request Content-Encoding Error"
				ResponseArray["nbr"] = 2
				w.WriteHeader(http.StatusBadRequest)
				json.NewEncoder(w).Encode(ResponseArray)
				return
			}
			result, _ := ioutil.ReadAll(rgzip)
			err := json.NewDecoder(bytes.NewReader(result)).Decode(&RequestArray)
			if err != nil {
				//ResponseArray["message"] = "Request Error"
				ResponseArray["nbr"] = 2
				w.WriteHeader(http.StatusBadRequest)
				json.NewEncoder(w).Encode(ResponseArray)
				return
			}
			ResponseArray = getAD3(RequestArray, RequestDetails)
			if len(ResponseArray) == 0 {
				w.WriteHeader(http.StatusNoContent)
				return
			} else {
				w.WriteHeader(http.StatusOK)
				gz := gzip.NewWriter(w)
				json.NewEncoder(gz).Encode(ResponseArray)
				gz.Close()
				return
			}
		default:
			// create header
			w.Header().Add("Content-Type", "application/json")
			err := json.NewDecoder(r.Body).Decode(&RequestArray)
			if err != nil {
				//ResponseArray["message"] = "Request Error"
				ResponseArray["nbr"] = 2
				w.WriteHeader(http.StatusBadRequest)
				json.NewEncoder(w).Encode(ResponseArray)
				return
			}
			ResponseArray = getAD3(RequestArray, RequestDetails)
			if len(ResponseArray) == 0 {
				w.WriteHeader(http.StatusNoContent)
				return
			} else {
				w.WriteHeader(http.StatusOK)
				json.NewEncoder(w).Encode(ResponseArray)
				return
			}
		}
	} else {
		// create header
		w.Header().Add("Content-Type", "application/json")
		ResponseArray["nbr"] = 2
		w.WriteHeader(http.StatusBadRequest)
		json.NewEncoder(w).Encode(ResponseArray)
		return
	}
}

// Function for getting AD v3.0
func getAD3(RequestArray *openrtb3.Request, RequestDetails map[string]interface{}) map[string]interface{} {
	Channel := make(chan map[string]interface{})
	ResponseArray := make(map[string]interface{})
	ErrorArray := djvalidate.ValidateRequest3(RequestArray)

	if len(ErrorArray) == 0 {
		go djad.Dsp_adprocessing(Channel, RequestArray, RequestDetails)
		ResponseArray = <-Channel
		return ResponseArray
	} else {
		//ResponseArray["message"] = "Request Error"
		ResponseArray["nbr"] = 2
		return ResponseArray
	}
}

// Function for getting AD v2.5
func getAD25(RequestArray *openrtb.BidRequest, RequestDetails map[string]interface{}) map[string]interface{} {
	fmt.Println("326")
	Channel := make(chan map[string]interface{})
	ResponseArray := make(map[string]interface{})
	ErrorArray := djvalidate.ValidateRequest25(RequestArray)
	if len(ErrorArray) == 0 {
		go djad.Dsp_adprocessing25(Channel, RequestArray, RequestDetails)
		ResponseArray = <-Channel
		return ResponseArray
	} else {
		//ResponseArray["message"] = "Request Error"
		ResponseArray["nbr"] = 2
		return ResponseArray
	}
}

// Function for processing Ad Click request
func processClickUrl(w http.ResponseWriter, r *http.Request) {
	var sync_table = djconstants.TablePrefix + "dj_dsp_cookie_sync"
	ProcessDetails := make(map[string]interface{})
	ProcessDetails["bidid"] = r.URL.Query().Get("bidid")
	ProcessDetails["bannerid"] = r.URL.Query().Get("bannerid")
	ProcessDetails["campaignid"] = r.URL.Query().Get("campaignid")
	ProcessDetails["oadest"] = r.URL.Query().Get("oadest")
	ProcessDetails["cookieid"] = r.URL.Query().Get("cookieid")
	insertClickURl := djmongo.MongoSaveClickImpression(ProcessDetails, 1)
	if insertClickURl != true {
		djlogger.Log.Println("Error in updating click count in Mongodb")
	}
	rows, err := djdb.DbQuery("INSERT INTO " + sync_table + " (adid,cookieid,bidid,campaignid) VALUES (" + ProcessDetails["bannerid"].(string) + ",'" + ProcessDetails["cookieid"].(string) + "','" + ProcessDetails["bidid"].(string) + "'," + ProcessDetails["campaignid"].(string) + ")	ON DUPLICATE KEY UPDATE adid = " + ProcessDetails["bannerid"].(string) + " ,  bidid = '" + ProcessDetails["bidid"].(string) + "' , campaignid = " + ProcessDetails["campaignid"].(string))
	if err != nil {
		djlogger.Log.Println("Error in inserting data in ", sync_table, " : ", err)
	}
	rows.Close()
	http.Redirect(w, r, ProcessDetails["oadest"].(string), http.StatusSeeOther)
}

// Function for processing Ad Click request
func processImpUrl(w http.ResponseWriter, r *http.Request) {
	ProcessDetails := make(map[string]interface{})
	ProcessDetails["bidid"] = r.URL.Query().Get("bidid")
	ProcessDetails["bannerid"] = r.URL.Query().Get("bannerid")
	ProcessDetails["campaignid"] = r.URL.Query().Get("campaignid")

	var view_count int

	fetch, err := djdb.DbQuery("SELECT views FROM  rv_campaigns where campaignid = '" + fmt.Sprint(ProcessDetails["campaignid"]) + "'")
	if err == nil {
		for fetch.Next() {
			fetch.Scan(&view_count)
		}
		fetch.Close()

	}
	if view_count > 1 {
		view_count = view_count - 1
		conn, _ := djdb.DbQuery("Update rv_campaigns SET views=" + fmt.Sprint(view_count) + "  where  campaignid=" + ProcessDetails["campaignid"].(string) + "")
		conn.Close()
	} else if view_count == 1 {

		connn, _ := djdb.DbQuery("Update rv_campaigns SET views=" + fmt.Sprint(view_count) + "  where  campaignid=" + ProcessDetails["campaignid"].(string) + "")
		connn.Close()
		conn, _ := djdb.DbQuery("Update rv_campaigns SET status= 3  where  campaignid=" + ProcessDetails["campaignid"].(string) + "")
		conn.Close()
	}

	insertImpURl := djmongo.MongoSaveClickImpression(ProcessDetails, 2)
	if insertImpURl != true {
		djlogger.Log.Println("Error in updating impression count in Mongodb")
	}

}

// Function for processing Ad Click request
func processRubiconDmpPixel(w http.ResponseWriter, r *http.Request) {
	cookieid := r.URL.Query().Get("cookieid")
	v := r.URL.Query().Get("v")
	url := djconstants.RubiconDmpURL + "?v=" + v + "&put=" + cookieid + "&expire=" + djconstants.RubiconExpireDays
	http.Redirect(w, r, url, http.StatusSeeOther)
}

// Function for processing Win Notice request
func processWinnotice(w http.ResponseWriter, r *http.Request) {

	//~ RequestDetails := getRequestDetails(r)
	//~ ProcessDetails := getProcessDetails(r)
	//~ ProcessDetails["url"] = RequestDetails["Host"].(string) + RequestDetails["URL"].(string)
	//~ insertWinnotice := djmongo.MongoSaveWinLossNotice(ProcessDetails, 1)
	//~ if insertWinnotice != true {
	//~ djlogger.Log.Println("Win Notice not inserted in Mongodb")
	//~ }

}

// Function for processing Win Notice request
func processBillingnotice(w http.ResponseWriter, r *http.Request) {

	var dspPrice_table = djconstants.TablePrefix + "djax_data_dsp_prices"
	var auction_price float64

	RequestDetails := getRequestDetails(r)
	ProcessDetails := getProcessDetails(r)
	ProcessDetails["url"] = RequestDetails["Host"].(string) + RequestDetails["URL"].(string)

	insertWinnotice := djmongo.MongoSaveWinLossNotice(ProcessDetails, 1)
	if insertWinnotice != true {
		djlogger.Log.Println("Win Notice not inserted in Mongodb")
	}

	if ProcessDetails["adid"].(string) == "SCREENING" {
		auction_price = 0.0
	} else {
		var reqPrice string
		switch v := ProcessDetails["price"].(type) {
		case []byte:
			reqPrice = string(v)
		default:
			reqPrice = v.(string)
		}
		auction_price = djextrafunc.StringToFloat(reqPrice, 64)
		auction_price /= 1000
	}

	rows, err := djdb.DbQuery("INSERT INTO "+dspPrice_table+" (ad_id,price,datetime) values ('"+ProcessDetails["adid"].(string)+"',?, ?)", auction_price, time.Now().UTC().Format("2006-01-02 15:04:05"))

	if err != nil {
		djlogger.Log.Println("Error in inserting data in ", dspPrice_table, " : ", err)
	}
	rows.Close()
}

// Function for processing Loss Notice request
func processLossnotice(w http.ResponseWriter, r *http.Request) {
	RequestDetails := getRequestDetails(r)
	ProcessDetails := getProcessDetails(r)
	ProcessDetails["url"] = RequestDetails["Host"].(string) + RequestDetails["URL"].(string)
	insertLossnotice := djmongo.MongoSaveWinLossNotice(ProcessDetails, 2)
	if insertLossnotice != true {
		djlogger.Log.Println("Loss Notice not inserted in Mongodb")
	}
}

// Function for processing DMP Pixel URL
func processDmpPixel(w http.ResponseWriter, r *http.Request) {
	var (
		count      int
		campaignid int
		cookieid   string
		viewer_id  string
	)
	adid := r.URL.Query().Get("campaignid")   //Campaign ID
	cookieid = r.URL.Query().Get("Dmp_id")    //DMP ID
	viewer_id = r.URL.Query().Get("viewerid") //"98e4e89jndf8y"

	fetch, err := djdb.DbQuery("SELECT count,campaignid, cookieid,viewer_id FROM djax_dmp_track where campaignid = '" + adid + "' AND cookieid = '" + cookieid + "' AND viewer_id= '" + viewer_id + "'")
	if err == nil {
		for fetch.Next() {
			fetch.Scan(&count, &campaignid, &cookieid, &viewer_id)
		}
	}
	fetch.Close()
	t := time.Now().Format("2006-01-02 15:04:05")
	if viewer_id != "" {
		count = count + 1
		updcount, err := djdb.PrepareData("Update djax_dmp_track SET count = ? ,interval_start = ? where campaignid = ? AND cookieid = ? AND viewer_id= ?")
		if err == nil {
			updcount.Exec(count, t, campaignid, cookieid, viewer_id)
		}
	}
	if viewer_id != "" && cookieid != "" {
		var count1 int
		djdb.DbQueryRow("SELECT count,campaignid, cookieid,viewer_id FROM djax_dmp_track where viewer_id= '"+viewer_id+"'").Scan(&count1, &campaignid, &cookieid, &viewer_id)
		rows, _ := djdb.DbNumRows("SELECT count,campaignid, cookieid,viewer_id FROM djax_dmp_track where viewer_id= '" + viewer_id + "'")
		if rows > 0 {
			if count1 > 0 || campaignid > 0 || cookieid != "" || viewer_id != "" {
				count1 = count1 + 1
				upd, err := djdb.PrepareData("Update djax_dmp_track SET count= ? , cookieid= ? where  viewer_id= ?")
				if err == nil {
					upd.Exec(count1, cookieid, viewer_id)
				}
			}
		} else {
			ins, _ := djdb.PrepareData("INSERT INTO djax_dmp_track (interval_start, campaignid, cookieid,viewer_id,count)	VALUES (?,?,?,?,?)")
			ins.Exec(t, campaignid, cookieid, viewer_id, 1)
		}

		if viewer_id != "" && cookieid == "" {
			djdb.DbQueryRow("DELETE FROM djax_dmp_track where viewer_id= '" + viewer_id + "'")
		}
	}
	addCookie(w, "dmp", cookieid)
	w.Header().Add("Content-Type", "image/gif")
	w.Header().Add("Content-Length", "43")
	base64.StdEncoding.DecodeString("R0lGODlhAQABAIAAAP///wAAACH5BAAAAAAALAAAAAABAAEAAAICRAEAOw==")
}

// Function for processing Mongo to Mysql Cron
func processMongoCron() {
	// Mysql Migration table
	fmt.Println("Mongo corn started")

	var migration_table = djconstants.TablePrefix + "djax_data_bkt_migration"
	defer func() {
		if err := recover(); err != nil {
			djlogger.Log.Println("Error occured : ", err, " Recovered from panic")
		}
	}()

	// Migration struct
	type ReqRes struct {
		Bidderid          int32  `json:"bidderid" bson:"bidderid"`
		Ad_id             int32  `json:"ad_id" bson:"ad_id"`
		Geo_country       string `json:"country" bson:"country"`
		Site_domain       string `json:"domain" bson:"domain"`
		App_domain        string `json:"app_domain" bson:"app_domain"`
		Device_os         string `json:"os" bson:"os"`
		Device_ip         string `json:"ip_address" bson:"ip_address"`
		Device_user_agent string `json:"user_agent" bson:"user_agent"`
		Device_language   string `json:"language" bson:"language"`
		Currency          string `json:"currency" bson:"currency"`
		User_age          int32  `json:"user_age" bson:"user_age"`
		User_gender       string `json:"gender" bson:"gender"`
		Device_type       int32  `json:"device_type" bson:"device_type"`
		Device_make       string `json:"device_make" bson:"device_make"`
		Device_model      string `json:"device_model" bson:"device_model"`
		Site_page_url     string `json:"page_url" bson:"page_url"`
		App_Storeurl      string `json:"storeurl" bson:"storeurl"`
		Site_ref_url      string `json:"ref_url" bson:"ref_url"`
		Datetime          string `json:"datetime" bson:"datetime"`

		//~ Geo_latitude        float64         `json:"lat" bson:"lat"`
		//~ Geo_longitude       float64         `json:"lon" bson:"lon"`
		//~ Device_conntype 	int32    		`json:"conntype" bson:"conntype"`
		//~ Geo_type          	int32           `json:"type" bson:"type"`
		//~ Geo_zip           	string          `json:"zip" bson:"zip"`
		//~ Geo_UTCOffset     	int32           `json:"utcoffset" bson:"utcoffset"`
		//~ Site_id      		string          `json:"site_id" bson:"site_id"`
		//~ Site_category       []string        `json:"cat" bson:"cat"`
	}

	// Migration Request struct
	type ReqMigration struct {
		Request       ReqRes `json:"_id" bson:"_id"`
		Request_count int    `json:"request_count" bson:"request_count"`
	}

	// Migration Response struct
	type ResMigration struct {
		Response            ReqRes  `json:"_id" bson:"_id"`
		Response_count      int     `json:"response_count" bson:"response_count"`
		Winnotice_count     int     `json:"winnotice_count" bson:"winnotice_count"`
		TestWinnotice_count int     `json:"testwinnotice_count" bson:"testwinnotice_count"`
		Adminshare_count    float64 `json:"adminshare_count" bson:"adminshare_count"`
		Price_count         float64 `json:"price_count" bson:"price_count"`
		Click_count         int     `json:"clickcount" bson:"clickcount"`
		Impression_count    int     `json:"impressioncount" bson:"impressioncount"`
	}
	t := time.Now()
	yC := t.Year()
	monC := djextrafunc.AddZeros(int(t.Month()))
	dC := djextrafunc.AddZeros(t.Day())
	hC := djextrafunc.AddZeros(t.Hour())
	minC := djextrafunc.AddZeros(djmongo.GetMin(t.Minute()))
	layout := "2006-01-02 15:04:00"
	str := strconv.Itoa(yC) + "-" + monC + "-" + dC + " " + hC + ":" + minC + ":00"
	t, _ = time.Parse(layout, str)
	djlogger.Log.Println("MongoDB to MYSQL Migration started at " + time.Now().Format("2006-01-02 15:04:05"))
	to := t.Add(time.Duration(-60) * time.Minute)
	y := to.Year()
	mon := int(to.Month())
	d := to.Day()
	h := to.Hour()
	min := to.Minute()
	tableSuffix := strconv.Itoa(y) + strconv.Itoa(mon) + strconv.Itoa(d) + strconv.Itoa(h) + strconv.Itoa(min)
	datetime := strconv.Itoa(y) + "-" + strconv.Itoa(mon) + "-" + strconv.Itoa(d) + " " + strconv.Itoa(h) + ":" + strconv.Itoa(min) + ":00"

	// Get a handle for mongo request collection

	clientReq, collectionReq, err := djmongo.MongoCollection(djconstants.MongoRequestTable + "_" + tableSuffix)
	// clientReq, collectionReq, err := djmongo.MongoCollection(djconstants.MongoRequestTable + "_"+request)

	if err != nil {
		djlogger.Log.Println("Error occured : ", err)
		return
	}
	defer clientReq.Close()
	// Get a handle for mongo response collection

	clientRes, collectionRes, err := djmongo.MongoCollection(djconstants.MongoResponseTable + "_" + tableSuffix)
	// clientRes, collectionRes, err := djmongo.MongoCollection(djconstants.MongoResponseTable + "_"+response)
	if err != nil {
		djlogger.Log.Println("Error occured : ", err)
		return
	}
	defer clientRes.Close()
	reqPipeline := []bson.M{
		{
			"$group": bson.M{
				"_id": bson.M{
					"bidderid":     "$bidderid",
					"country":      "$geo.country",
					"domain":       "$site.domain",
					"app_domain":   "$app.domain",
					"os":           "$device.os",
					"ip_address":   "$device.ip",
					"user_agent":   "$device.ua",
					"language":     "$device.language",
					"currency":     "$cur",
					"user_age":     "$user.yob",
					"gender":       "$user.gender",
					"device_type":  "$device.devicetype",
					"device_make":  "$device.make",
					"device_model": "$device.model",
					"page_url":     "$site.page",
					"storeurl":     "$app.storeurl",
					"ref_url":      "$site.refpage",
				},
				"request_count": bson.M{
					"$sum": 1,
				},
			},
		},
	}
	resPipeline := []bson.M{
		{
			"$group": bson.M{
				"_id": bson.M{
					"bidderid":     "$bidderid",
					"ad_id":        "$ad_id",
					"country":      "$geo.country",
					"domain":       "$site.domain",
					"os":           "$device.os",
					"ip_address":   "$device.ip",
					"user_agent":   "$device.ua",
					"language":     "$device.language",
					"currency":     "$cur",
					"user_age":     "$user.yob",
					"gender":       "$user.gender",
					"device_type":  "$device.devicetype",
					"device_make":  "$device.make",
					"device_model": "$device.model",
					"page_url":     "$site.page",
					"ref_url":      "$site.refpage",
				},
				"response_count": bson.M{
					"$sum": 1,
				},
				"winnotice_count": bson.M{
					"$sum": "$win_notice",
				},
				"testwinnotice_count": bson.M{
					"$sum": "$test_win_notice",
				},
				"adminshare_count": bson.M{
					"$sum": "$adminshare",
				},
				"price_count": bson.M{
					"$sum": "$price",
				},
				"clickcount": bson.M{
					"$sum": "$click",
				},
				"impressioncount": bson.M{
					"$sum": "$impression",
				},
			},
		},
	}
	var (
		reqresult []ReqMigration
		resresult []ResMigration
	)
	err = collectionReq.Pipe(reqPipeline).All(&reqresult)
	if err != nil {
		djlogger.Log.Println(err)
	}
	err = collectionRes.Pipe(resPipeline).All(&resresult)
	if err != nil {
		djlogger.Log.Println(err)
	}

	var i int = 0
	var Reqquery string

	Reqquery = "INSERT INTO " + migration_table + " (bidderid,country,domain,os,ip_address,user_agent,language,currency,user_age,gender,device_type,device_make,device_model,page_url,ref_url,request_count,datatime,date_created) VALUES "

	if reqresult != nil {

		djlogger.Log.Println("resuest start time :", time.Now().UnixMilli())
		for _, v := range reqresult {
			var Devicetype string

			if strings.Contains(v.Request.Site_ref_url, "'") {
				fmt.Println("ref url replaced")
				v.Request.Site_ref_url = strings.Replace(v.Request.Site_ref_url, "'", "\\'", -1)
			}
			if strings.Contains(v.Request.Site_page_url, "'") {
				fmt.Println("page url replaced")

				v.Request.Site_page_url = strings.Replace(v.Request.Site_page_url, "'", "\\'", -1)
			}

			if v.Request.App_domain != "" {
				v.Request.Site_domain = v.Request.App_domain
			}
			if v.Request.App_Storeurl != "" {
				v.Request.Site_page_url = v.Request.App_Storeurl
			}

			if v.Request.Device_type == 1 || v.Request.Device_type == 4 {
				Devicetype = "Mobile"
			} else if v.Request.Device_type == 2 {
				Devicetype = "Personal Computer"
			} else if v.Request.Device_type == 3 {
				Devicetype = "Connected TV"
			} else if v.Request.Device_type == 5 {
				Devicetype = "Tablet"
			} else if v.Request.Device_type == 6 {
				Devicetype = "Connected Device"
			} else if v.Request.Device_type == 7 {
				Devicetype = "Set top Box"
			}

			v.Request.Site_page_url = strings.ReplaceAll(v.Request.Site_page_url, "'", "")
			v.Request.Site_page_url = strings.ReplaceAll(v.Request.Site_page_url, `"`, "")
			if i == 0 {
				Reqquery = Reqquery + "('" + fmt.Sprint(v.Request.Bidderid) + "','" + v.Request.Geo_country + "','" + v.Request.Site_domain + "','" + v.Request.Device_os + "','" + v.Request.Device_ip + "','" + v.Request.Device_user_agent + "','" + v.Request.Device_language + "','" + v.Request.Currency + "','" + fmt.Sprint(y-int(v.Request.User_age)) + "','" + v.Request.User_gender + "','" + Devicetype + "','" + v.Request.Device_make + "','" + v.Request.Device_model + "','" + v.Request.Site_page_url + "','" + v.Request.Site_ref_url + "','" + fmt.Sprint(v.Request_count) + "','" + datetime + "','" + fmt.Sprint(time.Now().UTC().Format("2006-01-02 15:04:05")) + "')"
			} else {
				Reqquery = Reqquery + ",('" + fmt.Sprint(v.Request.Bidderid) + "','" + v.Request.Geo_country + "','" + v.Request.Site_domain + "','" + v.Request.Device_os + "','" + v.Request.Device_ip + "','" + v.Request.Device_user_agent + "','" + v.Request.Device_language + "','" + v.Request.Currency + "','" + fmt.Sprint(y-int(v.Request.User_age)) + "','" + v.Request.User_gender + "','" + Devicetype + "','" + v.Request.Device_make + "','" + v.Request.Device_model + "','" + v.Request.Site_page_url + "','" + v.Request.Site_ref_url + "','" + fmt.Sprint(v.Request_count) + "','" + datetime + "','" + fmt.Sprint(time.Now().UTC().Format("2006-01-02 15:04:05")) + "')"
			}
			i++
		}
		djlogger.Log.Println("i", i)

		djlogger.Log.Println("resuest end time :", time.Now().UnixMilli())

		Reqquery += ";"

		data, _ := ioutil.ReadFile("sql/rv_djax_data_bkt_migration.sql")
		jsContent := string(data)

		SQL_iNSERT := Reqquery

		jsContent = strings.ReplaceAll(jsContent, "SQL_INSERT", SQL_iNSERT)

		content := []byte(jsContent)
		err := ioutil.WriteFile("sql/rv_djax_data_bkt_migration.sql", content, 0644)
		if err != nil {
			fmt.Println("Error writing to file:", err)

		}

		// Set the CSV file path
		FilePath := djconstants.SQLFile+"/rv_djax_data_bkt_migration.sql"

		// Build the mysql command
		cmd := exec.Command(
			"mysql",
			"--host", djconstants.DbHost,
			"--port", djconstants.DbPort,
			"--user", djconstants.DbUser,
			"--password="+djconstants.DbPass,
			"--database", djconstants.DbName,
			"--execute", "source "+FilePath,
		)

		// Set the environment variable to allow processing the SQL file
		cmd.Env = append(os.Environ(), "MYSQL_PWD="+djconstants.DbPass)

		// Execute the command
		output, err := cmd.CombinedOutput()
		if err != nil {
			fmt.Println("Error running mysql command:", err)
			fmt.Println(string(output))
		}

		dataaa, _ := ioutil.ReadFile("sql/rv_djax_data_bkt_migration.sql")
		jsContenttt := string(dataaa)

		SQL_iNSERTt := "SQL_INSERT"

		jsContenttt = strings.ReplaceAll(jsContenttt, fmt.Sprint(Reqquery), SQL_iNSERTt)

		contentttt := []byte(jsContenttt)
		errq := ioutil.WriteFile("sql/rv_djax_data_bkt_migration.sql", contentttt, 0644)
		if errq != nil {
			fmt.Println("Error writing to file:", errq)

		}

		fmt.Println("Mongo corn stopped")

	}

	var Resquery string
	var j int = 0
	Resquery = "INSERT INTO " + migration_table + " (bidderid,ad_id,country,domain,os,ip_address,user_agent,language,currency,user_age,gender,device_type,device_make,device_model,page_url,ref_url,response_count,win_notice_count,test_win_notice_count,admin_share,total_amount,click_count,impression_count,datatime,date_created) VALUES "

	if resresult != nil {

		for _, v := range resresult {

			if strings.Contains(v.Response.Site_ref_url, "'") {
				fmt.Println("ref url replaced")
				v.Response.Site_ref_url = strings.Replace(v.Response.Site_ref_url, "'", "\\'", -1)
			}
			if strings.Contains(v.Response.Site_page_url, "'") {
				fmt.Println("page url replaced")

				v.Response.Site_page_url = strings.Replace(v.Response.Site_page_url, "'", "\\'", -1)
			}

			v.Response.Site_page_url = strings.ReplaceAll(v.Response.Site_page_url, "'", "")
			v.Response.Site_page_url = strings.ReplaceAll(v.Response.Site_page_url, `"`, "")
			if j == 0 {
				Resquery = Resquery + "('" + fmt.Sprint(v.Response.Bidderid) + "','" + fmt.Sprint(v.Response.Ad_id) + "','" + v.Response.Geo_country + "','" + v.Response.Site_domain + "','" + v.Response.Device_os + "','" + v.Response.Device_ip + "','" + v.Response.Device_user_agent + "','" + v.Response.Device_language + "','" + v.Response.Currency + "','" + fmt.Sprint(y-int(v.Response.User_age)) + "','" + v.Response.User_gender + "','" + fmt.Sprint(v.Response.Device_type) + "','" + v.Response.Device_make + "','" + v.Response.Device_model + "','" + v.Response.Site_page_url + "','" + v.Response.Site_ref_url + "','" + fmt.Sprint(v.Response_count) + "','" + fmt.Sprint(v.Winnotice_count) + "','" + fmt.Sprint(v.TestWinnotice_count) + "','" + fmt.Sprint(v.Adminshare_count) + "','" + fmt.Sprint(v.Price_count) + "','" + fmt.Sprint(v.Click_count) + "','" + fmt.Sprint(v.Impression_count) + "','" + datetime + "','" + fmt.Sprint(time.Now().UTC().Format("2006-01-02 15:04:05")) + "')"
			} else {
				Resquery = Resquery + ",('" + fmt.Sprint(v.Response.Bidderid) + "','" + fmt.Sprint(v.Response.Ad_id) + "','" + v.Response.Geo_country + "','" + v.Response.Site_domain + "','" + v.Response.Device_os + "','" + v.Response.Device_ip + "','" + v.Response.Device_user_agent + "','" + v.Response.Device_language + "','" + v.Response.Currency + "','" + fmt.Sprint(y-int(v.Response.User_age)) + "','" + v.Response.User_gender + "','" + fmt.Sprint(v.Response.Device_type) + "','" + v.Response.Device_make + "','" + v.Response.Device_model + "','" + v.Response.Site_page_url + "','" + v.Response.Site_ref_url + "','" + fmt.Sprint(v.Response_count) + "','" + fmt.Sprint(v.Winnotice_count) + "','" + fmt.Sprint(v.TestWinnotice_count) + "','" + fmt.Sprint(v.Adminshare_count) + "','" + fmt.Sprint(v.Price_count) + "','" + fmt.Sprint(v.Click_count) + "','" + fmt.Sprint(v.Impression_count) + "','" + datetime + "','" + fmt.Sprint(time.Now().UTC().Format("2006-01-02 15:04:05")) + "')"
			}
			j++

		}
		Resquery += ";"

		resdataata, _ := ioutil.ReadFile("sql/rv_djax_data_bkt_migration_res.sql")
		resjsContent := string(resdataata)

		RES_SQL_iNSERT := Resquery

		resjsContent = strings.ReplaceAll(resjsContent, "SQL_INSERT", RES_SQL_iNSERT)

		rescontent := []byte(resjsContent)
		reserr1 := ioutil.WriteFile("sql/rv_djax_data_bkt_migration_res.sql", rescontent, 0644)
		if reserr1 != nil {
			fmt.Println("Error writing to file:", reserr1)

		}

		// Set the CSV file path
		ResFilePath := djconstants.SQLFile+"/rv_djax_data_bkt_migration_res.sql"

		// Build the mysql command
		rescmd := exec.Command(
			"mysql",
			"--host", djconstants.DbHost,
			"--port", djconstants.DbPort,
			"--user", djconstants.DbUser,
			"--password="+djconstants.DbPass,
			"--database", djconstants.DbName,
			"--execute", "source "+ResFilePath,
		)

		// Set the environment variable to allow processing the SQL file
		rescmd.Env = append(os.Environ(), "MYSQL_PWD="+djconstants.DbPass)

		// Execute the command
		_, reserr := rescmd.CombinedOutput()
		if reserr != nil {
			fmt.Println(reserr)
		}

		resdataaa, _ := ioutil.ReadFile("sql/rv_djax_data_bkt_migration_res.sql")
		resjsContenttt := string(resdataaa)

		Res_SQL_iNSERTt := "SQL_INSERT"

		resjsContenttt = strings.ReplaceAll(resjsContenttt, fmt.Sprint(Resquery), Res_SQL_iNSERTt)

		rescontentttt := []byte(resjsContenttt)
		reserrq := ioutil.WriteFile("sql/rv_djax_data_bkt_migration_res.sql", rescontentttt, 0644)
		if reserrq != nil {
			fmt.Println("Error writing to file:", reserrq)

		}
		fmt.Println("Mongo corn stopped")
	}
	djlogger.Log.Println("MongoDB to MYSQL Migration ended at " + time.Now().Format("2006-01-02 15:04:05"))
	fmt.Println("Mongo corn stopped")
}

// Function for processing Mysql to Mysql Cron
func processMysqlCron() {
	// Mysql tables
	fmt.Println("mysql cron started")
	var report_table = djconstants.TablePrefix + "dj_dsp_advanced_reports"
	var migration_table = djconstants.TablePrefix + "djax_data_bkt_migration"
	var country_table = djconstants.TablePrefix + "country"

	defer func() {
		if err := recover(); err != nil {
			djlogger.Log.Println("Error occured : ", err, " Recovered from panic")
		}
	}()

	t := time.Now()
	/* layout := "2006-01-02 15:04:05"
	str := "2020-04-28 18:00:00"
	t, _ := time.Parse(layout, str)
	log.Println(t) */
	yC := t.Year()
	monC := djextrafunc.AddZeros(int(t.Month()))
	dC := djextrafunc.AddZeros(t.Day())
	hC := djextrafunc.AddZeros(t.Hour())
	layout := "2006-01-02 15:04:00"
	str := strconv.Itoa(yC) + "-" + monC + "-" + dC + " " + hC + ":00:00"
	t, _ = time.Parse(layout, str)
	djlogger.Log.Println("MYSQL to MYSQL Migration started at " + time.Now().Format("2006-01-02 15:04:00"))
	start := t.Add(time.Duration(-120) * time.Minute).Format("2006-01-02 15:04:05")
	end := t.Add(time.Duration(-61) * time.Minute).Format("2006-01-02 15:04:05")
	// start:="2023-12-22 12:00:00	"
	//end:="2023-12-22 12:59:00"
	sel_data := "bidderid,ad_id,country,domain,os,ip_address,user_agent,language,currency,user_age,gender,device_type,device_make,device_model,page_url,ref_url,SUM(request_count) as request_count, SUM(response_count) as response_count,SUM(win_notice_count) as win_notice_count,SUM(test_win_notice_count) as test_win_notice_count,SUM(click_count) as click_count,SUM(impression_count) as impression_count,SUM(total_amount) as total_amount,SUM(admin_share) as admin_share,datatime,date_created"
	whr := "datatime BETWEEN '" + start + "' AND '" + end + "'"
	group_by := "bidderid,country,domain,os,ip_address,user_agent,language,currency,user_age,gender,device_type,device_make,device_model,page_url,ref_url"
	// rows, err := djdb.DbQuery("SELECT " + sel_data + " FROM " + migration_table + " GROUP BY " + group_by)
	rows, err := djdb.DbQuery("SELECT " + sel_data + " FROM " + migration_table + " WHERE " + whr + " GROUP BY " + group_by)
	// defer func() {
	// 	err := rows.Close()
	// 	if err != nil {
	// 		djlogger.Log.Println(err)
	// 	}
	// }()

	country_1 := make(map[string]interface{})
	country_2 := make(map[string]interface{})
	country_3 := make(map[string]interface{})
	country_4 := make(map[string]interface{})

	arr1 := redisClient.GetKey("country_1", &country_1)
	if arr1 != nil {
		fmt.Println("Key expired or error in getting redis key: ", arr1.Error())
	}
	arr2 := redisClient.GetKey("country_2", &country_2)
	if arr2 != nil {
		fmt.Println("Key expired or error in getting redis key: ", arr2.Error())
	}
	arr3 := redisClient.GetKey("country_3", &country_3)
	if arr3 != nil {
		fmt.Println("Key expired or error in getting redis key: ", arr3.Error())
	}
	arr4 := redisClient.GetKey("country_4", &country_4)
	if arr4 != nil {
		fmt.Println("Key expired or error in getting redis key: ", arr4.Error())
	}

	var Migration string = "INSERT INTO " + report_table + " (bidderid,ad_id,country,country_name,domain,os,ip,user_agent,language,currency,age,gender,device_type,device_make,device_model,page_url,ref_url,request_count,response_count,win_notice_count,test_win_notice_count,click_count,impression_count,total_amount,admin_share,datatime,date_created) VALUES "
	var i int = 0
	if err != nil {
		fmt.Println(err)
		djlogger.Log.Println(err)
	} else {
		for rows.Next() {
			// fmt.Println("973")
			var (
				bidderid              int
				ad_id                 int
				geo_country           sql.NullString
				site_domain           sql.NullString
				device_os             sql.NullString
				device_ip             sql.NullString
				device_user_agent     sql.NullString
				device_language       sql.NullString
				currency              sql.NullString
				user_age              sql.NullInt64
				user_gender           sql.NullString
				device_type           sql.NullString
				device_make           sql.NullString
				device_model          sql.NullString
				site_page_url         sql.NullString
				site_ref_url          sql.NullString
				request_count         sql.NullInt64
				response_count        sql.NullInt64
				win_notice_count      sql.NullInt64
				test_win_notice_count sql.NullInt64
				click_count           sql.NullInt64
				impression_count      sql.NullInt64
				total_amount          sql.NullFloat64
				admin_share           sql.NullFloat64
				datatime              sql.NullString
				date_created          sql.NullString
			)
			err2 := rows.Scan(&bidderid, &ad_id, &geo_country, &site_domain, &device_os, &device_ip, &device_user_agent, &device_language, &currency, &user_age, &user_gender, &device_type, &device_make, &device_model, &site_page_url, &site_ref_url, &request_count, &response_count, &win_notice_count, &test_win_notice_count, &click_count, &impression_count, &total_amount, &admin_share, &datatime, &date_created)
			if err2 != nil {
				fmt.Println("err2", err2)
				djlogger.Log.Println(err2)
			} else {
				// fmt.Println("err2", 1007)
				var geo_country_id int
				var geo_country_name string
				djdb.DbQueryRow("SELECT id,name  FROM "+country_table+"  WHERE country_code = '"+geo_country.String+"' OR iso_countycode_alpha3  = '"+geo_country.String+"'  LIMIT 1").Scan(&geo_country_id, &geo_country_name)

				// _, err := djdb.DbQuery("INSERT INTO "+report_table+" (bidderid,ad_id,country,country_name,domain,os,ip,user_agent,language,currency,age,gender,device_type,device_make,device_model,page_url,ref_url,request_count,response_count,win_notice_count,test_win_notice_count,click_count,impression_count,total_amount,admin_share,datatime,date_created) VALUES(?,?,?,'"+geo_country_name+"','"+site_domain.String+"','"+device_os.String+"','"+device_ip.String+"','"+device_user_agent.String+"','"+device_language.String+"','"+currency.String+"',?,'"+user_gender.String+"',?,'"+device_make.String+"','"+device_model.String+"','"+site_page_url.String+"','"+site_ref_url.String+"',?,?,?,?,?,?,?,?,?,?)", bidderid, ad_id, geo_country_id, int(user_age.Int64), int(device_type.Int64), int(request_count.Int64), int(response_count.Int64), int(win_notice_count.Int64), int(test_win_notice_count.Int64), int(click_count.Int64), int(impression_count.Int64), float64(total_amount.Float64), float64(admin_share.Float64), start, time.Now().Format("2006-01-02 15:04:05"))
				// if err != nil {
				// 	djlogger.Log.Println(err)
				// }

				// if val, ok := country_1[geo_country.String]; ok {
				// 	//do something here
				// }

				site_page_url.String = strings.ReplaceAll(site_page_url.String, "'", "")
				site_page_url.String = strings.ReplaceAll(site_page_url.String, `"`, "")

				if i == 0 {
					fmt.Println("1020")
					Migration = Migration + "('" + fmt.Sprint(bidderid) + "','" + fmt.Sprint(ad_id) + "','" + fmt.Sprint(geo_country_id) + "','" + geo_country_name + "','" + site_domain.String + "','" + device_os.String + "','" + device_ip.String + "','" + device_user_agent.String + "','" + device_language.String + "','" + currency.String + "','" + fmt.Sprint(int(user_age.Int64)) + "','" + user_gender.String + "','" + device_type.String + "','" + device_make.String + "','" + device_model.String + "','" + site_page_url.String + "','" + site_ref_url.String + "','" + fmt.Sprint(int(request_count.Int64)) + "','" + fmt.Sprint(int(response_count.Int64)) + "','" + fmt.Sprint(int(win_notice_count.Int64)) + "','" + fmt.Sprint(int(test_win_notice_count.Int64)) + "','" + fmt.Sprint(int(click_count.Int64)) + "','" + fmt.Sprint(int(impression_count.Int64)) + "','" + fmt.Sprint(float64(total_amount.Float64)) + "','" + fmt.Sprint(float64(admin_share.Float64)) + "','" + fmt.Sprint(start) + "','" + fmt.Sprint(time.Now().Format("2006-01-02 15:04:05")) + "')"
					// + fmt.Sprint(start) + "','" + fmt.Sprint(time.Now().Format("2006-01-02 15:04:05")) + "')"
					// fmt.Println("query", Migration)
				} else {
					Migration = Migration + ",('" + fmt.Sprint(bidderid) + "','" + fmt.Sprint(ad_id) + "','" + fmt.Sprint(geo_country_id) + "','" + geo_country_name + "','" + site_domain.String + "','" + device_os.String + "','" + device_ip.String + "','" + device_user_agent.String + "','" + device_language.String + "','" + currency.String + "','" + fmt.Sprint(int(user_age.Int64)) + "','" + user_gender.String + "','" + device_type.String + "','" + device_make.String + "','" + device_model.String + "','" + site_page_url.String + "','" + site_ref_url.String + "','" + fmt.Sprint(int(request_count.Int64)) + "','" + fmt.Sprint(int(response_count.Int64)) + "','" + fmt.Sprint(int(win_notice_count.Int64)) + "','" + fmt.Sprint(int(test_win_notice_count.Int64)) + "','" + fmt.Sprint(int(click_count.Int64)) + "','" + fmt.Sprint(int(impression_count.Int64)) + "','" + fmt.Sprint(float64(total_amount.Float64)) + "','" + fmt.Sprint(float64(admin_share.Float64)) + "','" + fmt.Sprint(start) + "','" + fmt.Sprint(time.Now().Format("2006-01-02 15:04:05")) + "')"
				}
				i++
			}
		}
		Migration += ";"
		// fmt.Println("query", Migration)
		// fmt.Println("1032")
		rows.Close()

		resdataata, _ := ioutil.ReadFile("sql/rv_dj_dsp_advanced_reports.sql")
		resjsContent := string(resdataata)

		RES_SQL_iNSERT := Migration

		resjsContent = strings.ReplaceAll(resjsContent, "SQL_INSERT", RES_SQL_iNSERT)

		rescontent := []byte(resjsContent)
		reserr1 := ioutil.WriteFile("sql/rv_dj_dsp_advanced_reports.sql", rescontent, 0644)
		if reserr1 != nil {
			// fmt.Println("1046")
			fmt.Println("Error writing to file:", reserr1)

		}

		// Set the CSV file path
		ResFilePath := djconstants.SQLFile+"/rv_dj_dsp_advanced_reports.sql"
		// fmt.Println("1050")

		// Build the mysql command
		rescmd := exec.Command(
			"mysql",
			"--host", djconstants.DbHost,
			"--port", djconstants.DbPort,
			"--user", djconstants.DbUser,
			"--password="+djconstants.DbPass,
			"--database", djconstants.DbName,
			"--execute", "source "+ResFilePath,
		)

		// Set the environment variable to allow processing the SQL file
		rescmd.Env = append(os.Environ(), "MYSQL_PWD="+djconstants.DbPass)

		// Execute the command
		output, reserr := rescmd.CombinedOutput()
		if reserr != nil {
			fmt.Println("Error executing command:", err)
			fmt.Println("Command output:", string(output))
		} else {
			fmt.Println("Command ran successfully. Output:", string(output))
		}
		if reserr != nil {
			fmt.Println("reserr", reserr)
		}

		resdataaa, _ := ioutil.ReadFile("sql/rv_dj_dsp_advanced_reports.sql")
		resjsContenttt := string(resdataaa)

		Res_SQL_iNSERTt := "SQL_INSERT"

		resjsContenttt = strings.ReplaceAll(resjsContenttt, fmt.Sprint(Migration), Res_SQL_iNSERTt)

		rescontentttt := []byte(resjsContenttt)
		reserrq := ioutil.WriteFile("sql/rv_dj_dsp_advanced_reports.sql", rescontentttt, 0644)
		fmt.Println("1082")
		if reserrq != nil {
			fmt.Println("1084")
			fmt.Println("Error writing to file:", reserrq)

		}

		djdb.DbQueryRow("delete from " + migration_table + " where " + whr)

		fmt.Println("Mysql cron stopped")
		djlogger.Log.Println("MYSQL to MYSQL Migration ended at " + time.Now().Format("2006-01-02 15:04:00"))
	}
}

// Cron Function
func executeCronJob() {
	// Mongo migration cron for every 15 minutes
	gocron.Every(15).Minute().Do(processMongoCron)

	// Mysql migration cron for every hour
	gocron.Every(1).Hour().Do(processMysqlCron)
	<-gocron.Start()
}

// Main Function
func main() {
	// Concurrently execute cron functions
	go executeCronJob()

	// processMongoCron()
	// processMysqlCron()
	//ipAddr, err := djextrafunc.ExternalIP()
	//if err != nil {
	//djlogger.Log.Println(err)
	ipAddr := djconstants.AppHost
	//}

	djlogger.Log.Println("Server started at " + djconstants.AppProtocol + ipAddr + djconstants.AppPort)
	log.Println("Server started at " + djconstants.AppProtocol + ipAddr + djconstants.AppPort)
	// djlogger.Log.Println("Server started at " + djconstants.ApphttpProtocol + ipAddr + djconstants.ApphttpPort)
	// log.Println("Server started at " + djconstants.ApphttpProtocol + ipAddr + djconstants.ApphttpPort)
	// http.Handler
	router := mux.NewRouter().StrictSlash(true)
	router.HandleFunc("/", home)
	router.HandleFunc(djconstants.DSPEndPoint, processRequest).Methods("POST")
	router.HandleFunc("/samplerequest", samplerequest).Methods("POST")
	router.HandleFunc("/loaderio-69ca9df62735546fd9d77b7059b55b83.txt", validataion).Methods("GET")

	router.HandleFunc(djconstants.WinNoticeEndPoint, processWinnotice).Methods("GET")
	router.HandleFunc(djconstants.BillingNoticeEndPoint, processBillingnotice).Methods("GET")
	router.HandleFunc(djconstants.LossNoticeEndPoint, processLossnotice).Methods("GET")
	router.HandleFunc(djconstants.ClickUrlEndPoint, processClickUrl).Methods("GET")
	router.HandleFunc(djconstants.ImpUrlEndPoint, processImpUrl).Methods("GET")
	router.HandleFunc(djconstants.DmpPixelEndPoint, processDmpPixel).Methods("GET")
	router.HandleFunc(djconstants.RubiconDmpPixelEndPoint, processRubiconDmpPixel).Methods("GET")
	//router.HandleFunc(djconstants.MongoCronEndPoint, processMongoCron)
	//router.HandleFunc(djconstants.MysqlCronEndPoint, processMysqlCron)

	srv := &http.Server{
		Addr:    djconstants.AppPort,
		Handler: router,
		TLSConfig: &tls.Config{
			MinVersion:               tls.VersionTLS12,
			MaxVersion:               tls.VersionTLS13,
			PreferServerCipherSuites: true,
		},
	}

	// srvs := &http.Server{
	// 	Addr:    djconstants.ApphttpPort,
	// 	Handler: router,
	// 	TLSConfig: &tls.Config{
	// 		MinVersion:               tls.VersionTLS12,
	// 		MaxVersion:               tls.VersionTLS13,
	// 		PreferServerCipherSuites: true,
	// 	},
	// }

	// srv.SetKeepAlivesEnabled(false)
	// srvs.SetKeepAlivesEnabled(false)

	// go func() {
	// 	if err := srvs.ListenAndServe(); err != nil {
	// 		panic(err)
	// 	}
	// }()

	// go func() {
	if err := srv.ListenAndServeTLS(djconstants.CertFile, djconstants.KeyFile); err != nil {
		panic(err)
	}
	// }()
	// select {}

	// go func() {
	// 	fmt.Println("http lS")
	// 	err := http.ListenAndServe(":8080", http.HandlerFunc(redirectToHTTPS))
	// 	if err != nil {
	// 		fmt.Println("Error redirecting HTTP to HTTPS:", err)
	// 	}
	// }()

	// err := http.ListenAndServeTLS(":2212", djconstants.CertFile, djconstants.KeyFile, router)
	//  fmt.Println("https lS")

	// if err != nil {
	// 	fmt.Println("Error starting HTTPS server:", err)
	// }

}

func redirectToHTTPS(w http.ResponseWriter, req *http.Request) {

	if req.TLS == nil {
		// Redirect to HTTPS
		target := "https://adserver.unitdsp.com:2212" + req.URL.Path

		if len(req.URL.RawQuery) > 0 {

			target += "?" + req.URL.RawQuery
		}
		// If the original request was a POST, change the method to GET

		// if req.Method == http.MethodGet {
		req.Method = http.MethodPost

		// req.Body = nil // Optionally remove the request body for GET requests
		// }
		http.Redirect(w, req, target, http.StatusMovedPermanently)
	} else {

		// Request is already over HTTPS, serve as usual
		http.DefaultServeMux.ServeHTTP(w, req)
	}
}
